# Open Data files for Try Decidim Français


This ZIP file contains files for studying and researching about this participation platform.


Generated on 29/10/2025 08:26


## Core

### users (9 resources)

* id: The unique identifier of the user
* name: The display name of user
* nickname: The username of the user
* about: The about text of the user
* avatar_url: The avatar of the user
* profile_url: The profile url
* direct_messages_enabled: Whether the user allows direct messages
* deleted: Whether the user is deleted or not
* badge: The badge of the user


### taxonomies (25 resources)

* id: The unique identifier of this taxonomy
* name: The name of this taxonomy
* parent_id: The unique identifiers of this taxonomy parent (if any)
* weight: The order in which this taxonomy is shown
* children_count: The count of the children that this taxonomy has
* taxonomizations_count: The count of the resources that use this taxonomy
* created_at: The date when this taxonomy was created
* updated_at: The date when this taxonomy was updated for the last time
* filters_count: The number of filters that is using this taxonomy
* filter_items_count: The number of items filters that are using this taxonomy
* part_of: Used to detect if this taxonomy is part of another taxonomy
* is_root: True if this taxonomy do not have any parent



## Spaces

### participatory_processes (16 resources)

* id: The unique identifier of this process
* title: The process title
* slug: The process slug (used for identification purposes, for the URL)
* reference: The unique reference of the space
* created_at: The date this space was created
* updated_at: The last date this space was updated
* published_at: The date this space was published
* follows_count: The number of users following this space
* short_description: A short description of the process
* description: A long description of the process
* promoted: Wheter the process is promoted or not
* url: The URL of the space
* subtitle: The subtitle of the process
* remote_hero_image_url: The URL of the process hero image
* announcement: The announcement (callout) information
* start_date: The start date of the process
* end_date: The end date of the process
* developer_group: The developer group of the process. This is the organization that is promoting the process.
* local_area: The local area of the process. This is the organization area where the process is taking place.
* meta_scope: The scope metadata of the process
* participatory_scope: The participatory scope of the process
* participatory_structure: The participatory structure of the process. This is how the process is decided.
* target: The target of the process. This is who is called to participate in the process.
* area: The area where the process is taking place
* participatory_process_group: The group of the process, if there is any
* scope: The scope of the process
* scopes_enabled: Whether the scopes are enabled or not
* participatory_process_type: The type of the process



## Components

### results (89 resources)

* id: The unique identifier of the result
* taxonomies: The taxonomies of the result
* parent: The parent result (if any) of the result
* title: The title of the result
* description: The description of the result
* start_date: The date when the result starts execution
* end_date: The date when the result ends execution and it is finished
* status: The current status of this result
* progress: The percentage of the execution of the result
* created_at: The date when the result was created
* updated_at: The last date this result was updated
* url: The URL where this result can be found
* component: The component that the result belongs to
* proposal_urls: The URLs of the proposals that are included in this result
* reference: The unique reference of the result
* children_count: The number of child results
* comments_count: The number of comments that this result has
* address: The address of the result (if any)
* latitude: The latitude of the result in case it has a physical location
* longitude: The longitude of the result in case it has a physical location


### result_comments (435 resources)

* id: The id for this comment
* created_at: The date when this comment was created
* body: The comment itself
* locale: The locale (language) that the participant had when leaving this comment
* author: The name of the participant that made this comment
* alignment: If this comment was a favour, against or neutral
* depth: The place where this comment is in the three of comments (if it is an answer or an answer of an answer)
* commentable_id: The unique id of the commentable
* commentable_type: The type of the commentable (if it was a result, a proposal, etc.)
* root_commentable_url: The URL of the resource that ties to this comment


### posts (7 resources)

* id: The unique identifier of this post
* author: The information of the author
* title: The title of the post
* body: The body of the post
* created_at: The date this post was created
* updated_at: The last date this post was updated
* published_at: The date this post was published
* likes_count: The number of likes this post has
* comments_count: The number of comments this post has
* follows_count: The number of follows this post has
* participatory_space: To which space (e.g. Participatory Process, or Assembly) this post belongs to
* component: The component that the post belongs to
* url: The URL for this post


### post_comments (24 resources)

* id: The id for this comment
* created_at: The date when this comment was created
* body: The comment itself
* locale: The locale (language) that the participant had when leaving this comment
* author: The name of the participant that made this comment
* alignment: If this comment was a favour, against or neutral
* depth: The place where this comment is in the three of comments (if it is an answer or an answer of an answer)
* commentable_id: The unique id of the commentable
* commentable_type: The type of the commentable (if it was a result, a proposal, etc.)
* root_commentable_url: The URL of the resource that ties to this comment


### projects (37 resources)

* id: The unique identifier of the project
* taxonomies: The taxonomies of the project
* participatory_space: To which space (e.g. Participatory Process, or Assembly) this project belongs to
* component: The component that the project belongs to
* title: The title of the project
* description: The description of the project
* budget: Data regarding the budget (e.g. "2021 Budget") of the project
* budget_amount: The total amount of the budget for this project
* confirmed_votes: The number of confirmed votes this project has received
* comments: The number of comments this project has received
* created_at: The date and time when the project was created
* url: The URL of the project
* address: The address of the project (if any)
* updated_at: The last date the project was updated
* selected_at: The time at which the project was selected
* reference: The unique reference of the project
* follows_count: The number of follows the project has
* latitude: The latitude of the project in case it has a physical location
* longitude: The longitude of the project in case it has a physical location
* related_proposals: The related proposals to this project
* related_proposal_titles: The titles of the related proposals
* related_proposal_urls: The URLs of the related proposals


### debates (7 resources)

* id: The unique identifier of the debate
* author: The data for the author of this debate
* title: The debate title
* description: The debate description
* instructions: Which are the instructions to comment in this debate
* start_time: When this debate starts, if it is an open debate and has a limited time
* end_time: When this debate ends, if it is an open debate and has a limited time
* information_updates: The updates that the author has made to the debate
* taxonomies: The taxonomies of the project
* participatory_space: To which space (e.g. Participatory Process, or Assembly) this debate belongs to
* component: The component that the debate belongs to
* reference: The unique identifier of the resource in this platform
* comments: The number of comments this debate has
* follows_count: The number of followers this debate has
* url: The URL where this debate can be found
* last_comment_at: The date when this debate was commented by the last time
* last_comment_by: The data of last comment made within the debate
* comments_enabled: Wether this debate has comments enabled or not
* conclusions: The conclusions of the debate if it was closed
* closed_at: The date when this debate was closed
* created_at: The date and time when the debate was created
* updated_at: The date of when the debate was last updated
* likes_count: The number of likes the debate has


### debate_comments (18 resources)

* id: The id for this comment
* created_at: The date when this comment was created
* body: The comment itself
* locale: The locale (language) that the participant had when leaving this comment
* author: The name of the participant that made this comment
* alignment: If this comment was a favour, against or neutral
* depth: The place where this comment is in the three of comments (if it is an answer or an answer of an answer)
* commentable_id: The unique id of the commentable
* commentable_type: The type of the commentable (if it was a result, a proposal, etc.)
* root_commentable_url: The URL of the resource that ties to this comment



